
using System;
using System.Collections.Generic;
using System.Text;

namespace PI.ZB.N1200.ELearning.BL.DBD.View
{
    public class Exercise : PI.FM.N000.Base.BL.DBD.BaseTable<BO.View.Exercise>
    {
        #region Static factory
        private static Exercise _factory = null;

        public static Exercise DBD
        {
            get
            {
                if (_factory == null)
                {
                    _factory = new Exercise();
                }
                return _factory;
            }
        }
        #endregion

        #region Override - Initialization
        protected override void InitializeTableName()
        {
            _tableName = "PIZB1200_ExerciseView";
        }

        protected override void InitializeProperties()
        {
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("TypeID", "TypeID", true));
            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("BranchID", "BranchID"));
            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("DifficultyID", "DifficultyID"));
            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("SubjectID", "SubjectID"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("Flags", "Flags"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("MaxPoints", "MaxPoints"));
            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("EstimateTimeSpan", "EstimateTimeSpan"));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("ISO639_3", "ISO639_3"));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("Title", "Title", true));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("XMLValue", "XMLValue"));
            Add(new PI.FM.N000.Base.BL.DBD.BoolProperty("IsActive", "IsActive"));
            Add(new PI.FM.N000.Base.BL.DBD.BoolProperty("IsStatistic", "IsStatistic"));
            Add(new PI.FM.N000.Base.BL.DBD.BoolProperty("IsResolveable", "IsResolveable"));
            Add(new PI.FM.N000.Base.BL.DBD.BoolProperty("IsRevisonActive", "IsRevisonActive"));
        }
        #endregion

        #region Commands definition
        public enum Commands
        {
            RestoreRandomBySearch = 10
        }
        #endregion

        #region Get Commands
        protected override Gemini.Core.BL.Interface.DBD.ICommand DoGetCommand(int CommandID)
        {
            switch (CommandID)
            {
                case (int)Commands.RestoreRandomBySearch  : return new Command_RestoreRandomBySearch();
            }

            return base.DoGetCommand(CommandID);
        }
        #endregion

        #region Additional Commands Classes
        class Command_RestoreRandomBySearch : PI.FM.N000.Base.BL.DBD.BaseCommand<BO.View.Exercise>
        {
            public Command_RestoreRandomBySearch() : base(PI.ZB.N1200.ELearning.BL.DBD.View.Exercise.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("UserID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("ContextObjectID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("CourseID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("UnitID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("ExerciseDifficultyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIZB1200_ExerciseView_RestoreRandomizeBySearch";
            }
        }
        #endregion

    }
}